#ifndef TransferListModel_H
#define TransferListModel_H

#include "transferitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class TransferListModel : public QAbstractListModel
{
    Q_OBJECT

#if QT_VERSION >= 0x040700
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool itemsSelected
               READ itemsSelected
               NOTIFY itemsSelectedChanged)
#endif

public:
    enum Roles {
        TitleRole = Qt::UserRole + 1,
        DownloadPathRole,
        StatusRole,
        StatusTextRole,
        StatusInfoRole,
        ProgressRole,
        SizeRole,
        CurrentIndexRole,
        TotalFilesRole,
        PriorityRole,
        PriorityTextRole,
        ServiceRole,
        TransferTypeRole,
        SelectedRole
    };

public:
    explicit TransferListModel(QObject *parent = 0);
    ~TransferListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    bool setData(const QModelIndex &index, const QVariant &value, int role);
#if QT_VERSION >= 0x040600
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    Q_INVOKABLE bool setData(int row, const QVariant &value, const QByteArray &role);
#endif
    QSharedPointer<TransferItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE TransferItem* getFromQML(int row) const;
#endif
    inline bool itemsSelected() const { return !m_selectedRows.isEmpty(); }

public slots:
    void toggleSelected(int row);
    void selectAll();
    void selectNone();
    void pauseSelectedTransfers();
    void resumeSelectedTransfers();
    void cancelSelectedTransfers();

private:
    void clearTransfers();
    void selectRow(int row);
    void unselectRow(int row);
    int indexOf(TransferItem *transfer) const;

private slots:
    void onTransferDataChanged();
    void onTransferRemoved(int row);

signals:
    void countChanged(int count);
    void itemsSelectedChanged(bool selected);

private:
    QList<int> m_selectedRows;
};

#endif // TransferListModel_H
