#include "transferlistdelegate.h"
#include "transferlistmodel.h"
#include "../base/utils.h"
#include <QPainter>
#include <QApplication>

TransferListDelegate::TransferListDelegate(QObject *parent) :
    ListDelegate(parent)
{
}

void TransferListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    ListDelegate::paint(painter, option, index);

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 8);
    textRect.setRight(textRect.right() - 124);
    textRect.setTop(textRect.top() + 5);

    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignTop, index.data(TransferListModel::TitleRole).toString());
    painter->setClipping(false);

    textRect.moveBottom(option.rect.bottom() - 5);

    painter->save();

    switch (index.data(TransferListModel::StatusRole).toInt()) {
    case Transfers::Failed:
        painter->setPen(Qt::red);
        break;
    case Transfers::Paused:
        painter->setPen(QApplication::palette().color(QPalette::Mid));
        break;
    default:
        painter->setPen(QApplication::palette().color(QPalette::Highlight));
    }

    painter->drawText(textRect, Qt::AlignBottom | Qt::TextSingleLine, index.data(TransferListModel::StatusTextRole).toString());
    painter->restore();

    switch (index.data(TransferListModel::TransferTypeRole).toInt()) {
    case Transfers::PlaylistDownload:
        painter->drawText(textRect, Qt::AlignBottom | Qt::AlignRight | Qt::TextSingleLine, QString("%1/%2").arg(index.data(TransferListModel::CurrentIndexRole).toInt()).arg(index.data(TransferListModel::TotalFilesRole).toInt()));
        break;
    default:
        painter->drawText(textRect, Qt::AlignBottom | Qt::AlignRight | Qt::TextSingleLine, Utils::fileSizeFromBytes(index.data(TransferListModel::SizeRole).toLongLong()));
        break;
    }

    QRect progressRect = option.rect;
    progressRect.setSize(QSize(100, 30));
    progressRect.moveTopRight(QPoint(option.rect.right() - 8, (option.rect.top() + option.rect.height() / 2 - progressRect.height() / 2)));

    int progress = index.data(TransferListModel::ProgressRole).toInt();

    QStyleOptionProgressBar progressBar;
    progressBar.rect = progressRect;
    progressBar.minimum = 0;
    progressBar.maximum = 100;
    progressBar.progress = progress;
    progressBar.text = QString::number(progress) + "%";
    progressBar.textVisible = true;

    QApplication::style()->drawControl(QStyle::CE_ProgressBar, &progressBar, painter);
}
