#ifndef TRACKINFOWINDOW_H
#define TRACKINFOWINDOW_H

#include "../base/trackitem.h"
#include <QWidget>
#include <QSharedPointer>

class QMenu;
class QLabel;
class SeparatorLabel;
class ThumbnailLabel;
class WaveformLabel;
class CommentListModel;
class QListView;
class QScrollArea;
class QVBoxLayout;

class TrackInfoWindow : public QWidget
{
    Q_OBJECT

public:
    explicit TrackInfoWindow(QSharedPointer<TrackItem> track, QWidget *parent = 0);
    ~TrackInfoWindow();

protected:
    void contextMenuEvent(QContextMenuEvent *event);

private slots:
    void playTrack();
    void queueTrack();
    void downloadTrack();
    void toggleFavourite();
    void showShareDialog();
    void showCommentDialog();
    void showUserChannel();
    void onFavouriteChanged(bool favourite);
    void onCommentsCountChanged(int count);
    void setThumbnails();
    void setMenuActions();

private:
    QSharedPointer<TrackItem> m_track;
    QMenu *m_contextMenu;
    QAction *m_playAction;
    QAction *m_queueAction;
    QAction *m_downloadAction;
    QAction *m_shareAction;
    QAction *m_favouritesAction;
    QAction *m_commentAction;
    QLabel *m_titleLabel;
    QLabel *m_artistLabel;
    QLabel *m_dateLabel;
    QLabel *m_genreLabel;
    QLabel *m_formatLabel;
    QLabel *m_sizeLabel;
    QLabel *m_lengthLabel;
    QLabel *m_playCountLabel;
    QLabel *m_downloadCountLabel;
    QLabel *m_descriptionLabel;
    ThumbnailLabel *m_thumbnailLabel;
    WaveformLabel *m_waveformLabel;
    SeparatorLabel *m_propertiesSeparator;
    SeparatorLabel *m_descriptionSeparator;
    SeparatorLabel *m_commentsSeparator;
    CommentListModel *m_commentsModel;
    QListView *m_commentsView;
    QScrollArea *m_scrollArea;
    QVBoxLayout *m_vbox;
};

#endif // TRACKINFOWINDOW_H
