#include "tabbutton.h"
#include <QPainter>
#include <QPaintEvent>

TabButton::TabButton(QWidget *parent) :
    QAbstractButton(parent),
    m_on(false)
{
    this->setFixedSize(72, 49);
}

TabButton::~TabButton() {}

void TabButton::paintEvent(QPaintEvent *event) {
    QPainter painter(this);

    QString state("normal");

    if (!this->isEnabled()) {
        state = "disabled";
    }
    else if ((this->isDown()) || (this->isOn())) {
        state = "pressed";
    }

    painter.drawImage(this->rect(), QImage(QString("/usr/share/themes/default/images/qgn_plat_toolbar_button_%1.png").arg(state)));

    this->icon().paint(&painter, this->rect());

    event->accept();
}

bool TabButton::isOn() const {
    return m_on;
}

void TabButton::setOn(bool on) {
    if (on != this->isOn()) {
        m_on = on;
        this->update();
    }
}
