#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>

class QLineEdit;
class QPushButton;
class QCheckBox;
class QComboBox;
class QDialogButtonBox;
class QTabWidget;
class QVBoxLayout;

class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(QWidget *parent = 0);
    ~SettingsDialog();
    
private slots:
    void loadSettings();
    void saveSettings();
    void showFileDialog();
    
private:
    QLineEdit *m_folderEdit;
    QPushButton *m_folderButton;
    QCheckBox *m_subfoldersCheckBox;
    QCheckBox *m_clipboardCheckBox;
    QCheckBox *m_scrobbleCheckBox;
    QCheckBox *m_onlineArchiveCheckBox;
    QCheckBox *m_transfersCheckBox;
    QComboBox *m_formatComboBox;
    QComboBox *m_transfersComboBox;
    QComboBox *m_languageComboBox;
    QDialogButtonBox *m_buttonBox;
    QTabWidget *m_tabWidget;
    QWidget *m_mediaTab;
    QWidget *m_transfersTab;
    QWidget *m_otherTab;
    QVBoxLayout *m_vbox;
};

#endif // SETTINGSDIALOG_H
