#ifndef SEARCHHISTORYDIALOG_H
#define SEARCHHISTORYDIALOG_H

#include <QDialog>

class SearchListModel;
class QListView;
class QModelIndex;
class QVBoxLayout;
class QDialogButtonBox;
class QMenu;

class SearchHistoryDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SearchHistoryDialog(SearchListModel *model, QWidget *parent = 0);
    ~SearchHistoryDialog();

private slots:
    void onListItemActivated(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void applySelectedSearchQuery();
    void removeSelectedSearchQuery();

signals:
    void searchQueryChosen(const QString &query);
    
private:
    SearchListModel *m_model;
    QListView *m_view;
    QMenu *m_contextMenu;
    QAction *m_applyAction;
    QAction *m_removeAction;
    QAction *m_clearAction;
    QDialogButtonBox *m_buttonBox;
    QVBoxLayout *m_vbox;
};

#endif // SEARCHHISTORYDIALOG_H
