#include "searchhistorydialog.h"
#include "../base/searchlistmodel.h"
#include <QListView>
#include <QMenu>
#include <QDialogButtonBox>
#include <QVBoxLayout>


SearchHistoryDialog::SearchHistoryDialog(SearchListModel *model, QWidget *parent) :
    QDialog(parent),
    m_model(model),
    m_view(new QListView(this)),
    m_contextMenu(new QMenu(this)),
    m_applyAction(m_contextMenu->addAction(tr("Apply"), this, SLOT(applySelectedSearchQuery()))),
    m_removeAction(m_contextMenu->addAction(tr("Remove"), this, SLOT(removeSelectedSearchQuery()))),
    m_clearAction(m_contextMenu->addAction(tr("Clear"), m_model, SLOT(clearSearches()))),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Cancel | QDialogButtonBox::Ok, Qt::Horizontal, this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowTitle(tr("Search history"));

    m_view->setModel(m_model);
    m_view->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_view->setContextMenuPolicy(Qt::CustomContextMenu);
    m_view->setEditTriggers(QListView::NoEditTriggers);

    m_vbox->addWidget(m_view);
    m_vbox->addWidget(m_buttonBox);

    this->connect(m_view, SIGNAL(activated(QModelIndex)), this, SLOT(onListItemActivated(QModelIndex)));
    this->connect(m_view, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(applySelectedSearchQuery()));
    this->connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
}

SearchHistoryDialog::~SearchHistoryDialog() {}

void SearchHistoryDialog::onListItemActivated(const QModelIndex &index) {
    if (index.isValid()) {
        emit searchQueryChosen(index.data().toString());
    }

    this->accept();
}

void SearchHistoryDialog::showContextMenu(const QPoint &pos) {
    if (m_view->currentIndex().isValid()) {
        m_contextMenu->setActiveAction(m_applyAction);
        m_contextMenu->popup(this->mapToGlobal(pos), m_applyAction);
    }
}

void SearchHistoryDialog::applySelectedSearchQuery() {
    if (m_view->currentIndex().isValid()) {
        emit searchQueryChosen(m_view->currentIndex().data().toString());
    }

    this->accept();
}

void SearchHistoryDialog::removeSelectedSearchQuery() {
    if (m_view->currentIndex().isValid()) {
        m_model->removeSearch(m_view->currentIndex().row());
    }
}
