#ifndef PLAYLISTLISTWINDOW_H
#define PLAYLISTLISTWINDOW_H

#include "../base/enums.h"
#include <QWidget>

class QListView;
class PlaylistListModel;
class QModelIndex;
class QVBoxLayout;

class PlaylistListWindow : public QWidget
{
    Q_OBJECT

public:
    explicit PlaylistListWindow(QWidget *parent = 0);
    ~PlaylistListWindow();

    void setPlaylistFeed(const QUrl &feed);
    void search(const QString &query, Queries::QueryOrder order);

private slots:
    void onListItemActivated(const QModelIndex &index);

private:
    PlaylistListModel *m_model;
    QListView *m_view;
    QVBoxLayout *m_vbox;
};

#endif // PLAYLISTLISTWINDOW_H
