#include "nowplayingbutton.h"
#include <QPainter>
#include <QPaintEvent>

NowPlayingButton::NowPlayingButton(Role buttonRole, QWidget *parent) :
    QAbstractButton(parent),
    m_role(buttonRole)
{
    this->setFixedSize(72, 49);
}

NowPlayingButton::~NowPlayingButton() {}

void NowPlayingButton::paintEvent(QPaintEvent *event) {
    QPainter painter(this);

    QString state("normal");

    if (!this->isEnabled()) {
        state = "disabled";
    }
    else if ((this->isDown()) || (this->isChecked())) {
        state = "pressed";
    }

    switch (m_role) {
    case List:
        painter.drawImage(this->rect(), QImage(QString("/usr/share/themes/default/images/qgn_plat_button_mplayer_playlist_%1.png").arg(state)));
        break;
    case Current:
        painter.drawImage(this->rect(), QImage(QString("/usr/share/themes/default/images/qgn_plat_button_mplayer_now_playing_%1.png").arg(state)));
        break;
    default:
        this->icon().paint(&painter, this->rect());
        break;
    }

    event->accept();
}
