#include "mychannelwindow.h"
#include "userprofilewindow.h"
#include "tracklistwindow.h"
#include "playlistlistwindow.h"
#include "grouplistwindow.h"
#include "userlistwindow.h"
#include "../base/feedurls.h"
#include <QTabBar>
#include <QStackedWidget>
#include <QVBoxLayout>
#include <QKeyEvent>

MyChannelWindow::MyChannelWindow(QWidget *parent) :
    QWidget(parent),
    m_profileTab(new UserProfileWindow("me", this)),
    m_tracksTab(0),
    m_favouritesTab(0),
    m_playlistsTab(0),
    m_groupsTab(0),
    m_followingsTab(0),
    m_tabBar(new QTabBar(this)),
    m_stack(new QStackedWidget(this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowTitle(tr("You"));
    this->setAttribute(Qt::WA_DeleteOnClose);

    m_tabBar->setDrawBase(false);
    m_tabBar->addTab(tr("Profile"));
    m_tabBar->addTab(tr("Tracks"));
    m_tabBar->addTab(tr("Favourites"));
    m_tabBar->addTab(tr("Sets"));
    m_tabBar->addTab(tr("Groups"));
    m_tabBar->addTab(tr("Followings"));

    m_stack->addWidget(m_profileTab);

    m_vbox->setContentsMargins(0, 0, 0, 0);
    m_vbox->setSpacing(0);
    m_vbox->addWidget(m_tabBar);
    m_vbox->addWidget(m_stack);

    this->connect(m_tabBar, SIGNAL(currentChanged(int)), this, SLOT(onCurrentTabChanged(int)));

    this->showProfile();
}

MyChannelWindow::~MyChannelWindow() {}

void MyChannelWindow::keyPressEvent(QKeyEvent *event) {
    switch (event->key()) {
    case Qt::Key_Left:
        m_tabBar->setCurrentIndex(m_tabBar->currentIndex() - 1);
        event->accept();
        return;
    case Qt::Key_Right:
        m_tabBar->setCurrentIndex(m_tabBar->currentIndex() + 1);
        event->accept();
        return;
    default:
        QWidget::keyPressEvent(event);
        return;
    }
}

void MyChannelWindow::showProfile() {
    m_stack->setCurrentWidget(m_profileTab);
    m_profileTab->setFocus(Qt::OtherFocusReason);
}

void MyChannelWindow::showTracks() {
    if (!m_tracksTab) {
        m_tracksTab = new TrackListWindow(this);
        m_stack->addWidget(m_tracksTab);
        m_tracksTab->setFocus(Qt::OtherFocusReason);
        m_tracksTab->setTrackFeed(UPLOADS_FEED);
    }

    m_stack->setCurrentWidget(m_tracksTab);
    m_tracksTab->setFocus(Qt::OtherFocusReason);
}

void MyChannelWindow::showFavourites() {
    if (!m_favouritesTab) {
        m_favouritesTab = new TrackListWindow(this);
        m_stack->addWidget(m_favouritesTab);
        m_favouritesTab->setFocus(Qt::OtherFocusReason);
        m_favouritesTab->setTrackFeed(FAVOURITES_FEED);
    }

    m_stack->setCurrentWidget(m_favouritesTab);
    m_favouritesTab->setFocus(Qt::OtherFocusReason);
}

void MyChannelWindow::showPlaylists() {
    if (!m_playlistsTab) {
        m_playlistsTab = new PlaylistListWindow(this);
        m_stack->addWidget(m_playlistsTab);
        m_playlistsTab->setFocus(Qt::OtherFocusReason);
        m_playlistsTab->setPlaylistFeed(PLAYLISTS_FEED);
    }

    m_stack->setCurrentWidget(m_playlistsTab);
    m_playlistsTab->setFocus(Qt::OtherFocusReason);
}

void MyChannelWindow::showGroups() {
    if (!m_groupsTab) {
        m_groupsTab = new GroupListWindow(this);
        m_stack->addWidget(m_groupsTab);
        m_groupsTab->setFocus(Qt::OtherFocusReason);
        m_groupsTab->setGroupFeed(GROUPS_FEED);
    }

    m_stack->setCurrentWidget(m_groupsTab);
    m_groupsTab->setFocus(Qt::OtherFocusReason);
}

void MyChannelWindow::showFollowings() {
    if (!m_followingsTab) {
        m_followingsTab = new UserListWindow(this);
        m_stack->addWidget(m_followingsTab);
        m_followingsTab->setFocus(Qt::OtherFocusReason);
        m_followingsTab->setUserFeed(FOLLOWINGS_FEED);
    }

    m_stack->setCurrentWidget(m_followingsTab);
    m_followingsTab->setFocus(Qt::OtherFocusReason);
}

void MyChannelWindow::onCurrentTabChanged(int index) {
    switch (index) {
    case 1:
        this->showTracks();
        return;
    case 2:
        this->showFavourites();
        return;
    case 3:
        this->showPlaylists();
        return;
    case 4:
        this->showGroups();
        return;
    case 5:
        this->showFollowings();
        return;
    default:
        this->showProfile();
        return;
    }
}
