#ifndef MEDIAPLAYERTOOLBAR_H
#define MEDIAPLAYERTOOLBAR_H

#include "../base/enums.h"
#include <QWidget>

class QToolButton;
class QLabel;
class QSlider;
class QHBoxLayout;

class MediaPlayerToolBar : public QWidget
{
    Q_OBJECT

public:
    explicit MediaPlayerToolBar(QWidget *parent = 0);
    ~MediaPlayerToolBar();

public slots:
    void startVolumeTimer();
    void stopVolumeTimer();

private slots:
    void onPlaybackQueueChanged(int count);
    void onPlaybackPositionChanged(qint64 position);
    void onPlaybackDurationChanged(qint64 duration);
    void onPlaybackModeChanged(Media::PlaybackMode playbackMode);
    void onSliderReleased();
    void onVolumeButtonClicked(bool checked);
    void onVolumeTimeout();

signals:
    void showVolumeControl(bool show);

private:
    QToolButton *m_volumeButton;
    QToolButton *m_playbackModeButton;
    QLabel *m_positionLabel;
    QLabel *m_durationLabel;
    QSlider *m_slider;
    QTimer *m_volumeTimer;
    QHBoxLayout *m_hbox;
};

#endif // MEDIAPLAYERTOOLBAR_H
