#include "listdelegate.h"
#include "../base/utils.h"
#include <QPainter>

ListDelegate::ListDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void ListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    QString imageName("qgn_plat_pane1_focus_passive");

    if ((option.state) & (QStyle::State_Selected)) {
        imageName = "qgn_plat_pane2_focus_active";
    }

    QImage image(QString("/usr/share/themes/default/images/%1.png").arg(imageName));

    Utils::drawBorderImage(painter, option.rect, image, 5, 5, 5, 5);
}

QSize ListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 74);
}
