#ifndef INFORMATIONNOTE_H
#define INFORMATIONNOTE_H

#include <QDialog>

class QLabel;
class QDialogButtonBox;
class QGridLayout;

class InformationNote : public QDialog
{
    Q_OBJECT

public:
    enum NoteType {
        Information = 0,
        Question,
        Warning
    };

    explicit InformationNote(QWidget *parent = 0);
    ~InformationNote();

    NoteType noteType() const;
    void setNoteType(NoteType type);

    QString message() const;
    void setMessage(const QString &message);

    static InformationNote* showInformation(QWidget *parent, const QString &message);
    static InformationNote* showQuestion(QWidget *parent, const QString &message);
    static InformationNote* showWarning(QWidget *parent, const QString &message);

public slots:
    void showInformation(const QString &message);
    void showQuestion(const QString &message);
    void showWarning(const QString &message);
    
protected:
    void paintEvent(QPaintEvent *event);

private:
    NoteType m_noteType;
    QLabel *m_iconLabel;
    QLabel *m_messageLabel;
    QDialogButtonBox *m_buttonBox;
    QGridLayout *m_grid;
};

#endif // INFORMATIONNOTE_H
