#ifndef INFORMATIONBANNER_H
#define INFORMATIONBANNER_H

#include <QWidget>

class InformationBanner : public QWidget
{
    Q_OBJECT

public:
    enum BannerType {
        Information = 0,
        Progress
    };

    explicit InformationBanner(QWidget *parent = 0);
    ~InformationBanner();

    QSize sizeHint() const;

    BannerType bannerType() const;
    void setBannerType(BannerType type);

    QString message() const;
    void setMessage(const QString &message);

    int maximumValue() const;
    int value() const;

    QString icon() const;
    void setIcon(const QString &icon);

    static void showInformation(QWidget *parent, const QString &message, const QString &icon = QString());
    static InformationBanner* showProgress(QWidget* parent, const QString &message, int numberOfOperations = 1);

public slots:
    void showInformation(const QString &message, const QString &icon = QString());
    void showProgress(const QString &message, int numberOfOperations = 1);
    void updateProgress(int progress);

    void setMaximumValue(int maximum);
    void setValue(int value);

protected:
    void showEvent(QShowEvent *event);
    void keyPressEvent(QKeyEvent *event);
    void timerEvent(QTimerEvent *event);
    void paintEvent(QPaintEvent *event);
    
private:
    QString m_message;
    QString m_icon;
    BannerType m_bannerType;
    int m_maximum;
    int m_value;
};

#endif // INFORMATIONBANNER_H
