#include "informationbanner.h"
#include "mainwindow.h"
#include "../base/utils.h"
#include <QPaintEvent>
#include <QPainter>
#include <QFontMetrics>
#include <QApplication>
#include <QStyleOptionProgressBar>

static const int defaultTimeOut = 4000;

InformationBanner::InformationBanner(QWidget *parent) :
    QWidget(parent),
    m_bannerType(Information),
    m_maximum(100),
    m_value(0)
{
    this->setFocusPolicy(Qt::NoFocus);
    this->setWindowFlags(Qt::ToolTip);
}

InformationBanner::~InformationBanner() {}

QSize InformationBanner::sizeHint() const {
    QRect textRect = QFontMetrics(this->font()).boundingRect(this->message());

    switch (this->bannerType()) {
    case Progress:
        return QSize(qMin(textRect.width() + 168, 600), qMax(textRect.height() + 24, 86));
    default:
        return QSize(qMin(textRect.width() + 92, 70), qMax(textRect.height() + 24, 86));
    }
}

void InformationBanner::showEvent(QShowEvent *event) {
    this->resize(this->sizeHint());
    this->move(800 - (this->width() + 8), MainWindow::instance()->isFullScreen() ? 0 : 60);

    switch (this->bannerType()) {
    case Information:
        this->startTimer(defaultTimeOut);
        break;
    default:
        break;
    }

    QWidget::showEvent(event);
}

void InformationBanner::keyPressEvent(QKeyEvent *event) {
    event->ignore();
}

void InformationBanner::timerEvent(QTimerEvent *event) {
    event->accept();
    this->killTimer(event->timerId());
    this->close();
}

void InformationBanner::paintEvent(QPaintEvent *event) {
    QPainter painter(this);

    int width = this->rect().width() / 2;
    int height = this->rect().height() / 2;

    Utils::drawBorderImage(&painter, QRect(0, 0, width, height), QImage("/usr/share/themes/default/images/qgn_plat_infoprint_frame_corner_top_left.png"), 8, 8, 8, 8);
    Utils::drawBorderImage(&painter, QRect(width - 1, 0, width, height), QImage("/usr/share/themes/default/images/qgn_plat_infoprint_frame_corner_top_right.png"), 8, 8, 8, 8);
    Utils::drawBorderImage(&painter, QRect(0, height - 1, width, height), QImage("/usr/share/themes/default/images/qgn_plat_infoprint_frame_corner_bottom_left.png"), 8, 8, 8, 8);
    Utils::drawBorderImage(&painter, QRect(width - 1, height - 1, width, height), QImage("/usr/share/themes/default/images/qgn_plat_infoprint_frame_corner_bottom_right.png"), 8, 8, 8, 8);

    QRect textRect = this->rect();

    switch (this->bannerType()) {
    case Progress:
    {
        textRect.setLeft(24);
        textRect.setRight(textRect.right() - 136);
        painter.drawText(textRect, Qt::AlignVCenter | Qt::TextWordWrap, this->message());

        QRect progressRect(textRect.right() + 12, height - 15, 100, 30);

        QStyleOptionProgressBar progressBar;
        progressBar.rect = progressRect;
        progressBar.minimum = 0;
        progressBar.maximum = this->maximumValue();
        progressBar.progress = this->value();

        QApplication::style()->drawControl(QStyle::CE_ProgressBar, &progressBar, &painter, this);
        break;
    }
    default:
        textRect.setLeft(62);
        textRect.setRight(textRect.right() - 24);
        painter.drawText(textRect, Qt::AlignVCenter | Qt::TextWordWrap, this->message());
        painter.drawImage(QRect(24, height - 13, 26, 26), QImage(this->icon().isEmpty() ? "/usr/share/icons/hicolor/26x26/hildon/qgn_note_infoprint.png" : this->icon()));
        break;
    }

    event->accept();
}

InformationBanner::BannerType InformationBanner::bannerType() const {
    return m_bannerType;
}

void InformationBanner::setBannerType(BannerType type) {
    if (!this->isVisible()) {
        m_bannerType = type;
    }
}

QString InformationBanner::message() const {
    return m_message;
}

void InformationBanner::setMessage(const QString &message) {
    m_message = message;
}

QString InformationBanner::icon() const {
    return m_icon;
}

void InformationBanner::setIcon(const QString &icon) {
    m_icon = icon;
}

int InformationBanner::maximumValue() const {
    return m_maximum;
}
void InformationBanner::setMaximumValue(int maximum) {
    if (!this->isVisible()) {
        m_maximum = maximum;
    }
}

int InformationBanner::value() const {
    return m_value;
}

void InformationBanner::setValue(int value) {
    if (value != this->value()) {
        m_value = value;

        if (value >= this->maximumValue()) {
            this->hide();
        }
        else {
            this->update();
        }
    }
}

void InformationBanner::showInformation(const QString &message, const QString &icon) {
    this->setBannerType(Information);
    this->setMessage(message);
    this->setIcon(icon);
    this->show();
}

void InformationBanner::showProgress(const QString &message, int numberOfOperations) {
    this->setBannerType(Progress);
    this->setMessage(message);
    this->setValue(0);
    this->setMaximumValue(numberOfOperations);
    this->show();
}

void InformationBanner::updateProgress(int progress) {
    this->setValue(progress);
}

void InformationBanner::showInformation(QWidget *parent, const QString &message, const QString &icon) {
    InformationBanner *banner = new InformationBanner(parent);
    banner->setAttribute(Qt::WA_DeleteOnClose);
    banner->showInformation(message, icon);
}

InformationBanner* InformationBanner::showProgress(QWidget *parent, const QString &message, int numberOfOperations) {
    InformationBanner *banner = new InformationBanner(parent);
    banner->showProgress(message, numberOfOperations);

    return banner;
}
