#include "grouplistwindow.h"
#include "grouplistdelegate.h"
#include "tracklistwindow.h"
#include "mainwindow.h"
#include "../base/grouplistmodel.h"
#include <QListView>
#include <QVBoxLayout>

GroupListWindow::GroupListWindow(QWidget *parent) :
    QWidget(parent),
    m_model(new GroupListModel(this)),
    m_view(new QListView(this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setAttribute(Qt::WA_DeleteOnClose);
    this->setFocusProxy(m_view);

    m_view->setModel(m_model);
    m_view->setItemDelegate(new GroupListDelegate(m_view));
    m_view->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    m_vbox->setContentsMargins(0, 0, 0, 0);
    m_vbox->addWidget(m_view);

    this->connect(m_view, SIGNAL(activated(QModelIndex)), this, SLOT(onListItemActivated(QModelIndex)));
}

GroupListWindow::~GroupListWindow() {}

void GroupListWindow::setGroupFeed(const QUrl &feed) {
    m_model->getGroups(feed);
}

void GroupListWindow::search(const QString &query, Queries::QueryOrder order) {
    this->setWindowTitle(QString("%1 ('%2')").arg(tr("Search")).arg(query));
    m_model->search(query, order);
}

void GroupListWindow::onListItemActivated(const QModelIndex &index) {
    if (index.isValid()) {
        TrackListWindow *window = new TrackListWindow(MainWindow::instance());
        window->getGroupTracks(m_model->get(index.row()));
        MainWindow::instance()->push(window);
    }
}
