#include "connectionlistdelegate.h"
#include "../base/connectionlistmodel.h"
#include <QPainter>

ConnectionListDelegate::ConnectionListDelegate(QObject *parent) :
    ListDelegate(parent)
{
}

void ConnectionListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    ListDelegate::paint(painter, option, index);

    QRect iconRect = option.rect;
    iconRect.setSize(QSize(24, 24));
    iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + 5));

    painter->drawImage(iconRect, QImage(index.data(ConnectionListModel::IconSourceRole).toString()).scaled(iconRect.size(), Qt::IgnoreAspectRatio, Qt::SmoothTransformation));

    if (index.data(ConnectionListModel::SelectedRole).toBool()) {
        iconRect.moveRight(option.rect.right() - 8);

        painter->drawImage(iconRect, QImage("/usr/share/icons/hicolor/26x26/hildon/qgn_list_continuous_multi_select.png"));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 40);
    textRect.setRight(textRect.right() - 40);

    painter->drawText(textRect, Qt::AlignVCenter, index.data(ConnectionListModel::DisplayNameRole).toString());
}

QSize ConnectionListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 34);
}
