#ifndef COMMENTDIALOG_H
#define COMMENTDIALOG_H

#include "../base/trackitem.h"
#include <QDialog>
#include <QSharedPointer>

class QPlainTextEdit;
class QDialogButtonBox;
class QVBoxLayout;
class QCheckBox;
class QLabel;

class CommentDialog : public QDialog
{
    Q_OBJECT

public:
    explicit CommentDialog(QSharedPointer<TrackItem> track, QWidget *parent = 0);
    ~CommentDialog();
    
private slots:
    void onCommentTextChanged();
    void submitComment();

private:
    QSharedPointer<TrackItem> m_track;
    qint64 m_timestamp;
    QLabel *m_commentLabel;
    QPlainTextEdit *m_commentEdit;
    QCheckBox *m_timestampCheckbox;
    QDialogButtonBox *m_buttonBox;
    QVBoxLayout *m_vbox;
};

#endif // COMMENTDIALOG_H
