#ifndef BUTTONBAR_H
#define BUTTONBAR_H

#include <QWidget>

class QAbstractButton;
class QGridLayout;

class ButtonBar : public QWidget
{
    Q_OBJECT

public:
    explicit ButtonBar(QWidget *parent = 0);
    ~ButtonBar();

    void addButton(QAbstractButton *button);
    void insertButton(QAbstractButton *button, int index);
    void removeButton(QAbstractButton *button);

protected:
    void paintEvent(QPaintEvent *event);
    
private:
    QGridLayout *m_grid;
};

#endif // BUTTONBAR_H
