#ifndef ARCHIVEWINDOW_H
#define ARCHIVEWINDOW_H

#include <QWidget>

class ArchiveTracksWindow;
class ArchivePlaylistsWindow;
class QTabBar;
class QStackedWidget;
class QVBoxLayout;

class ArchiveWindow : public QWidget
{
    Q_OBJECT

public:
    explicit ArchiveWindow(QWidget *parent = 0);
    ~ArchiveWindow();

protected:
    void keyPressEvent(QKeyEvent *event);

private:
    void showTracks();
    void showPlaylists();

private slots:
    void onCurrentTabChanged(int index);

private:
    ArchiveTracksWindow *m_tracksTab;
    ArchivePlaylistsWindow *m_playlistsTab;
    QTabBar *m_tabBar;
    QStackedWidget *m_stack;
    QVBoxLayout *m_vbox;
};

#endif // ARCHIVEWINDOW_H
