#ifndef ARCHIVETRACKSWINDOW_H
#define ARCHIVETRACKSWINDOW_H

#include <QWidget>

class QListView;
class ArchiveTrackModel;
class QModelIndex;
class QMenu;
class QVBoxLayout;

class ArchiveTracksWindow : public QWidget
{
    Q_OBJECT

public:
    explicit ArchiveTracksWindow(QWidget *parent = 0);
    ~ArchiveTracksWindow();
    
private slots:
    void onListItemActivated(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void showSelectedTrack();
    void playSelectedTrack();
    void queueSelectedTrack();

private:
    ArchiveTrackModel *m_model;
    QListView *m_view;
    QMenu *m_contextMenu;
    QAction *m_viewAction;
    QAction *m_playAction;
    QAction *m_queueAction;
    QVBoxLayout *m_vbox;
};

#endif // ARCHIVETRACKSWINDOW_H
