#ifndef ARCHIVEPLAYLISTTRACKSWINDOW_H
#define ARCHIVEPLAYLISTTRACKSWINDOW_H

#include "../base/playlistitem.h"
#include <QWidget>
#include <QSharedPointer>

class ArchiveTrackModel;
class ThumbnailLabel;
class SeparatorLabel;
class QScrollArea;
class QListView;
class QLabel;
class QPushButton;
class QModelIndex;
class QMenu;
class QVBoxLayout;

class ArchivePlaylistTracksWindow : public QWidget
{
    Q_OBJECT

public:
    explicit ArchivePlaylistTracksWindow(QSharedPointer<PlaylistItem> playlist, QWidget *parent = 0);
    ~ArchivePlaylistTracksWindow();

protected:
    void contextMenuEvent(QContextMenuEvent *event);

private slots:
    void setThumbnail();
    void setMenuActions();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void playPlaylist();
    void queuePlaylist();
    void onListItemActivated(const QModelIndex &index);
    void showTracksContextMenu(const QPoint &pos);
    void showSelectedTrack();
    void playSelectedTrack();
    void queueSelectedTrack();
    void addSelectedTrackToFavourites();

private:
    QSharedPointer<PlaylistItem> m_playlist;
    QMenu *m_contextMenu;
    QAction *m_playAction;
    QAction *m_queueAction;
    QMenu *m_tracksMenu;
    QAction *m_viewTrackAction;
    QAction *m_playTrackAction;
    QAction *m_queueTrackAction;
    QAction *m_favouritesAction;
    QLabel *m_titleLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_artistLabel;
    QLabel *m_dateLabel;
    ThumbnailLabel *m_thumbnail;
    QPushButton *m_playButton;
    SeparatorLabel *m_separator1;
    SeparatorLabel *m_separator2;
    QScrollArea *m_scrollArea;
    QListView *m_view;
    ArchiveTrackModel *m_model;
    QVBoxLayout *m_vbox;
};

#endif // ARCHIVEPLAYLISTTRACKSWINDOW_H
