#include "archiveplaylistswindow.h"
#include "playlistlistdelegate.h"
#include "archiveplaylisttrackswindow.h"
#include "mainwindow.h"
#include "../base/archiveplaylistmodel.h"
#include <QListView>
#include <QVBoxLayout>

ArchivePlaylistsWindow::ArchivePlaylistsWindow(QWidget *parent) :
    QWidget(parent),
    m_model(new ArchivePlaylistModel(this)),
    m_view(new QListView(this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowTitle(tr("Playlists"));
    this->setAttribute(Qt::WA_DeleteOnClose);
    this->setFocusProxy(m_view);

    m_view->setModel(m_model);
    m_view->setItemDelegate(new PlaylistListDelegate(m_view));
    m_view->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    m_vbox->setContentsMargins(0, 0, 0, 0);
    m_vbox->addWidget(m_view);

    this->connect(m_view, SIGNAL(activated(QModelIndex)), this, SLOT(onListItemActivated(QModelIndex)));
}

ArchivePlaylistsWindow::~ArchivePlaylistsWindow() {}

void ArchivePlaylistsWindow::onListItemActivated(const QModelIndex &index) {
    if (index.isValid()) {
        ArchivePlaylistTracksWindow *window = new ArchivePlaylistTracksWindow(m_model->get(index.row()), MainWindow::instance());
        MainWindow::instance()->push(window);
    }
}
