#ifndef GROUPITEM_H
#define GROUPITEM_H

#include "enums.h"
#include <QObject>
#include <QUrl>
#include <QVariantMap>
#include <QString>

class GroupItem : public QObject
{
    Q_OBJECT

#if QT_VERSION >= 0x040700
    Q_PROPERTY(QString id
               READ id
               CONSTANT)
    Q_PROPERTY(QString title
               READ title
               NOTIFY titleChanged)
    Q_PROPERTY(QString artist
               READ artist
               NOTIFY artistChanged)
    Q_PROPERTY(QString artistId
               READ artistId
               NOTIFY artistIdChanged)
    Q_PROPERTY(QUrl artistAvatarUrl
               READ artistAvatarUrl
               NOTIFY artistAvatarUrlChanged)
    Q_PROPERTY(QString description
               READ description
               NOTIFY descriptionChanged)
    Q_PROPERTY(QString date
               READ date
               NOTIFY dateChanged)
    Q_PROPERTY(QUrl thumbnailUrl
               READ thumbnailUrl
               NOTIFY thumbnailUrlChanged)
    Q_PROPERTY(int trackCount
               READ trackCount
               NOTIFY trackCountChanged)
    Q_PROPERTY(bool member
               READ member
               WRITE setMember
               NOTIFY memberChanged)
    Q_PROPERTY(Services::AudioService service
               READ service
               NOTIFY serviceChanged)
#endif

public:
    explicit GroupItem(QObject *parent = 0);
    explicit GroupItem(GroupItem *group, QObject *parent = 0);
    explicit GroupItem(const QVariantMap &group, QObject *parent = 0);
    ~GroupItem() {}
    Q_INVOKABLE void loadGroup(GroupItem *group);
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; emit titleChanged(title); }
    inline QString artist() const { return m_artist; }
    inline void setArtist(const QString &artist) { m_artist = artist; emit artistChanged(artist); }
    inline QString artistId() const { return m_artistId; }
    inline void setArtistId(const QString &id) { m_artistId = id; emit artistIdChanged(id); }
    inline QUrl artistAvatarUrl() const { return m_artistAvatarUrl; }
    inline void setArtistAvatarUrl(const QUrl &url) { m_artistAvatarUrl = url; emit artistAvatarUrlChanged(url); }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; emit descriptionChanged(description); }
    inline QString date() const { return m_date; }
    inline void setDate(const QString &date) { m_date = date; emit dateChanged(date); }
    inline QUrl thumbnailUrl() const { return m_thumbnailUrl; }
    inline void setThumbnailUrl(const QUrl &url) { m_thumbnailUrl = url; emit thumbnailUrlChanged(url); }
    inline int trackCount() const { return m_trackCount; }
    inline void setTrackCount(int count) { m_trackCount = count; emit trackCountChanged(count); }
    inline bool member() const { return m_member; }
    inline void setMember(bool member) { m_member = member; emit memberChanged(member); }
    inline Services::AudioService service() const { return m_service; }
    inline void setService(Services::AudioService service) { m_service = service; emit serviceChanged(service); }
    inline bool operator ==(GroupItem *other) { return other->id() == this->id(); }

signals:
    void titleChanged(const QString &title);
    void artistChanged(const QString &artist);
    void artistIdChanged(const QString &id);
    void artistAvatarUrlChanged(const QUrl &url);
    void descriptionChanged(const QString &description);
    void dateChanged(const QString &date);
    void thumbnailUrlChanged(const QUrl &url);
    void trackCountChanged(int count);
    void memberChanged(bool member);
    void serviceChanged(Services::AudioService service);

private:
    QString m_id;
    QString m_title;
    QString m_artist;
    QString m_artistId;
    QUrl m_artistAvatarUrl;
    QString m_description;
    QString m_date;
    QUrl m_thumbnailUrl;
    int m_trackCount;
    bool m_member;
    Services::AudioService m_service;
};

#endif // GROUPITEM_H
