#include "groupitem.h"
#include "utils.h"

GroupItem::GroupItem(QObject *parent) :
    QObject(parent),
    m_trackCount(0),
    m_member(false),
    m_service(Services::NoService)
{
}

GroupItem::GroupItem(GroupItem *group, QObject *parent) :
    QObject(parent),
    m_id(group->id()),
    m_title(group->title()),
    m_artist(group->artist()),
    m_artistId(group->artistId()),
    m_artistAvatarUrl(group->artistAvatarUrl()),
    m_description(group->description()),
    m_date(group->date()),
    m_thumbnailUrl(group->thumbnailUrl()),
    m_trackCount(group->trackCount()),
    m_member(group->member()),
    m_service(group->service())
{
}

GroupItem::GroupItem(const QVariantMap &group, QObject *parent) :
    QObject(parent),
    m_id(group.value("id").toString()),
    m_title(group.value("name").toString()),
    m_artist(group.value("creator").toMap().value("username").toString()),
    m_artistId(group.value("creator").toMap().value("id").toString()),
    m_artistAvatarUrl(group.value("creator").toMap().value("avatar_url").toString()),
    m_description(group.value("description").toString().remove('\r')),
    m_date(Utils::localDateTimeFromString(group.value("created_at").toString().section(' ', 0, 1))),
    m_thumbnailUrl(group.value("artwork_url").toString()),
    m_trackCount(group.value("track_count").toInt()),
    m_member(false),
    m_service(Services::SoundCloud)
{
}

void GroupItem::loadGroup(GroupItem *group) {
    this->setId(group->id());
    this->setTitle(group->title());
    this->setArtist(group->artist());
    this->setArtistId(group->artistId());
    this->setArtistAvatarUrl(group->artistAvatarUrl());
    this->setDescription(group->description());
    this->setDate(group->date());
    this->setThumbnailUrl(group->thumbnailUrl());
    this->setTrackCount(group->trackCount());
    this->setMember(group->member());
    this->setService(group->service());
}
