#include "exploremodel.h"

ExploreModel::ExploreModel(QObject *parent) :
    QAbstractListModel(parent)
{
#if QT_VERSION >= 0x040600
    m_roleNames[NameRole] = "name";
    m_roleNames[TypeRole] = "type";
    m_roleNames[FeedRole] = "feed";
#if QT_VERSION < 0x050000
    this->setRoleNames(m_roleNames);
#endif
#endif

    this->addItem(Queries::Tracks, QUrl("http://api.soundcloud.com/tracks.json?limit=30&order=created_at&filter=public"), tr("Latest tracks"));
    this->addItem(Queries::Tracks, QUrl("http://api.soundcloud.com/tracks.json?limit=30&order=hotness&filter=public"), tr("Hottest tracks"));
    this->addItem(Queries::Users, QUrl("http://api.soundcloud.com/users.json?limit=30"), tr("People"));
    this->addItem(Queries::Groups, QUrl("http://api.soundcloud.com/groups.json?limit=30"), tr("Groups"));

    emit countChanged(this->rowCount());
}

#if QT_VERSION >= 0x050000
QHash<int, QByteArray> ExploreModel::roleNames() const {
    return m_roleNames;
}
#endif

int ExploreModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return m_list.size();
}

QVariant ExploreModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case NameRole:
        return m_list.at(index.row()).name;
    case TypeRole:
        return m_list.at(index.row()).type;
    case FeedRole:
        return m_list.at(index.row()).feed;
    default:
        return QVariant();
    }
}

#if QT_VERSION >= 0x040600
QVariant ExploreModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}
#endif

void ExploreModel::addItem(Queries::QueryType type, const QUrl &feed, const QString &name) {
    ExploreItem item;
    item.type = type;
    item.feed = feed;
    item.name = name;

    this->beginInsertRows(QModelIndex(), this->rowCount(), this->rowCount());
    m_list.append(item);
    this->endInsertRows();
}
