#ifndef ENUMS_H
#define ENUMS_H

#include <QObject>
#include <QNetworkProxy>

class AudioFormats : public QObject
{
    Q_OBJECT

    Q_ENUMS(Format)

public:
    enum Format {
        OriginalFormat = 0,
        MP3,
        Unknown
    };
};

class Queries : public QObject
{
    Q_OBJECT

    Q_ENUMS(QueryType)
    Q_ENUMS(QueryOrder)

public:
    enum QueryType {
        Tracks = 0,
        Playlists,
        Users,
        Groups,
        Unknown
    };

    enum QueryOrder {
        Date = 0,
        Hotness
    };
};

class Services : public QObject
{
    Q_OBJECT

    Q_ENUMS(AudioService)

public:
    enum AudioService {
        SoundCloud = 0,
        NoService
    };
};

class Activities : public QObject
{
    Q_OBJECT

    Q_ENUMS(ActivityType)

public:
    enum ActivityType {
        Track = 0,
        Playlist,
        TrackSharing,
        Comment,
        Favouriting
    };
};

class Transfers : public QObject
{
    Q_OBJECT

    Q_ENUMS(TransferStatus)
    Q_ENUMS(TransferPriority)
    Q_ENUMS(TransferType)

public:
    enum TransferStatus {
        Paused = 0,
        Cancelled,
        Failed,
        Completed,
        Queued,
        Connecting,
        Downloading,
        Uploading
    };

    enum TransferPriority {
        HighPriority = 0,
        NormalPriority,
        LowPriority
    };

    enum TransferType {
        TrackDownload = 0,
        PlaylistDownload,
        TrackUpload,
        PlaylistUpload
    };
};

class ScreenOrientation : public QObject
{
    Q_OBJECT

    Q_ENUMS(Orientation)

public:
    enum Orientation {
#ifdef Q_WS_SAILFISH
        LockPortrait = 1,
        LockLandscape = 2,
        LockPortraitInverted = 4,
        LockLandcapeInverted = 8,
        Automatic = 15
#else
        Automatic = 0,
        LockPortrait,
        LockLandscape
#endif
    };
};

class NetworkProxyType : public QObject
{
    Q_OBJECT

    Q_ENUMS(ProxyType)

public:
    enum ProxyType {
        Socks5Proxy = QNetworkProxy::Socks5Proxy,
        HttpProxy = QNetworkProxy::HttpProxy,
        HttpCachingProxy = QNetworkProxy::HttpCachingProxy
    };
};

class Media : public QObject
{
    Q_OBJECT

    Q_ENUMS(PlaybackMode State)

public:
    enum PlaybackMode {
        Sequential = 0,
        RepeatAll,
        RepeatOne
    };

    enum State {
        Stopped = 0,
        Buffering,
        Playing,
        Paused,
        Error
    };
};

#endif // ENUMS_H
