TEMPLATE = app
TARGET = musikloud
QT += sql network

HEADERS += $$files(src/base/*.h)
SOURCES += $$files(src/base/*.cpp)

contains(DEFINES,Q_WS_SAILFISH) {
    QT += quick dbus multimedia
    DEFINES += QML_USER_INTERFACE
    HEADERS += $$files(src/sailfish/*.h) \
        $$files(src/mediaplayer/mobility/*.h)
    SOURCES += $$files(src/sailfish/*.cpp) \
        $$files(src/mediaplayer/mobility/*.cpp)
    RESOURCES = qml/sailfish/resources.qrc

#    OTHER_FILES += $$files(qml/sailfish/*.*)

    target.path = /usr/bin
    desktop.files = desktop/sailfish/musikloud.desktop
    desktop.path = /usr/share/applications
    icon80.path = /usr/share/icons/hicolor/80x80/apps
    icon80.files = desktop/sailfish/musikloud80.png
    icon64.path = /usr/share/icons/hicolor/64x64/apps
    icon64.files = desktop/sailfish/musikloud64.png
    dbus_service.path = /usr/share/dbus-1/services
    dbus_service.files = dbus/sailfish/com.maemo.MusiKloud.service
    dbus_interface.path = /usr/share/dbus-1/interfaces
    dbus_interface.files = dbus/sailfish/com.maemo.MusiKloud.xml
    contentaction.path = /usr/share/contentaction
    contentaction.files = contentaction/musikloud.xml

    INSTALLS += desktop icon80 icon64 dbus_service dbus_interface contentaction

    include(src/sailfish/sailfishapplication/sailfishapplication.pri)
}

contains(DEFINES,Q_WS_MAEMO_4) {
    QT += dbus
    CONFIG += link_pkgconfig
    PKGCONFIG += gstreamer-1.0
    HEADERS += $$files(src/maemo4/*.h) \
        $$files(src/mediaplayer/gstreamer/*.h)
    SOURCES += $$files(src/maemo4/*.cpp) \
        $$files(src/mediaplayer/gstreamer/*.cpp)
    RESOURCES = src/maemo4/resources.qrc

    target.path = /opt/musikloud/bin
    desktop.path = /usr/share/applications/hildon
    desktop.files = desktop/maemo4/musikloud.desktop
    icon40.path = /usr/share/icons/hicolor/40x40/apps
    icon40.files = desktop/maemo4/40x40/musikloud.png
    icon32.path = /usr/share/icons/hicolor/32x32/apps
    icon32.files = desktop/maemo4/32x32/musikloud.png
    icon16.path = /usr/share/icons/hicolor/16x16/apps
    icon16.files = desktop/maemo4/16x16/musikloud.png
    iconScalable.files = desktop/maemo4/scalable/musikloud.png
    iconScalable.path = /usr/share/icons/hicolor/scalable/apps
    translations.path = /opt/musikloud/translations
    translations.files = $$files(src/maemo4/translations/*.*)
    dbus_service.path = /usr/share/dbus-1/services
    dbus_service.files = dbus/maemo4/com.maemo.MusiKloud.service
    dbus_interface.path = /usr/share/dbus-1/interfaces
    dbus_interface.files = dbus/maemo4/com.maemo.MusiKloud.xml

    INSTALLS += desktop icon40 icon32 icon16 iconScalable translations dbus_service dbus_interface
}

maemo5 {
    DEFINES += MEDIA_PLAYERS_ENABLED
    QT += maemo5 dbus webkit
    CONFIG += mobility12
    MOBILITY += multimedia
    HEADERS += $$files(src/maemo5/*.h) \
        $$files(src/mediaplayer/mobility/*.h)
    SOURCES += $$files(src/maemo5/*.cpp) \
        $$files(src/mediaplayer/mobility/*.cpp)
    RESOURCES = src/maemo5/resources.qrc

    target.path = /opt/musikloud/bin
    desktop.path = /usr/share/applications/hildon
    desktop.files = desktop/maemo5/musikloud.desktop
    icon.path = /usr/share/icons/hicolor/64x64/apps
    icon.files = desktop/maemo5/musikloud64.png
    translations.path = /opt/musikloud/translations
    translations.files = $$files(src/maemo5/translations/*.*)
    dbus_service.path = /usr/share/dbus-1/services
    dbus_service.files = dbus/maemo5/com.maemo.MusiKloud.service
    dbus_interface.path = /usr/share/dbus-1/interfaces
    dbus_interface.files = dbus/maemo5/com.maemo.MusiKloud.xml

    INSTALLS += desktop icon translations dbus_service dbus_interface
}

contains(MEEGO_EDITION,harmattan) {
    DEFINES += QML_USER_INTERFACE IN_APP_UPDATES
    QT += dbus declarative
    CONFIG += qdeclarative-boostable \
        libtuiclient \
        share-ui-common \
        mobility
    MOBILITY += multimedia
    HEADERS += $$files(src/harmattan/*.h) \
        $$files(src/mediaplayer/mobility/*.h)
    SOURCES += $$files(src/harmattan/*.cpp) \
        $$files(src/mediaplayer/mobility/*.cpp)
    RESOURCES = qml/harmattan/resources.qrc

    OTHER_FILES += $$files(qml/harmattan/*.qml)

    target.path = /opt/musikloud/bin
    desktop.path = /usr/share/applications
    desktop.files = desktop/harmattan/musikloud.desktop
    icon80.path = /usr/share/icons/hicolor/80x80/apps
    icon80.files = desktop/harmattan/musikloud80.png
    icon64.path = /usr/share/icons/hicolor/64x64/apps
    icon64.files = desktop/harmattan/musikloud64.png
    dbus_service.path = /usr/share/dbus-1/services
    dbus_service.files = dbus/harmattan/com.maemo.MusiKloud.service
    dbus_interface.path = /usr/share/dbus-1/interfaces
    dbus_interface.files = dbus/harmattan/com.maemo.MusiKloud.xml
    contentaction.path = /usr/share/contentaction
    contentaction.files = contentaction/musikloud.xml
    resources.path = /opt/musikloud/resources
    resources.files = $$files(resources/*.*)

    INSTALLS += desktop icon80 icon64 dbus_service dbus_interface resources contentaction
}

symbian {
    DEFINES += QML_USER_INTERFACE SYMBIAN_OS IN_APP_UPDATES
    MMP_RULES += "DEBUGGABLE_UDEBONLY"
    TARGET = musikloud_0x20068c6a
    QT += declarative
    CONFIG += qt-components mobility
    MOBILITY += multimedia
    INCLUDEPATH += MW_LAYER_SYSTEMINCLUDE
    LIBS += -L\\epoc32\\release\\armv5\\lib -lremconcoreapi
    LIBS += -L\\epoc32\\release\\armv5\\lib -lremconinterfacebase
    TARGET.EPOCHEAPSIZE = 0x20000 0x8000000
    TARGET.EPOCSTACKSIZE = 0x14000
    TARGET.CAPABILITY += NetworkServices ReadUserData
    TARGET.UID3 = 0xE561675F //0x20068c6a
    DEPLOYMENT.display_name = MusiKloud
    VERSION = 1.5.3
    ICON = desktop/symbian/musikloud.svg

    vendorinfo += "%{\"Stuart Howarth\"}" ":\"Stuart Howarth\""
    stupidnokia = "; Default dependency to Qt Quick Components for Symbian library" \
        "(0x200346DE), 1, 1, 0, {\"Qt Quick components for Symbian\"}"

    my_deployment.pkg_prerules += vendorinfo stupidnokia

    DEPLOYMENT += my_deployment
    HEADERS += $$files(src/symbian/*.h) \
        $$files(src/mediaplayer/mobility/*.h)
    SOURCES += $$files(src/symbian/*.cpp) \
        $$files(src/mediaplayer/mobility/*.cpp)
    RESOURCES = qml/symbian/resources.qrc

    OTHER_FILES += $$files(qml/symbian/*.qml)
}

contains(DEFINES,IN_APP_UPDATES) {
    HEADERS += src/updatemanager/updatemanager.h
    SOURCES += src/updatemanager/updatemanager.cpp
}

INSTALLS += target
