#ifndef ENUMS_H
#define ENUMS_H

#include <QObject>
#include <QNetworkProxy>

class AudioFormats : public QObject
{
    Q_OBJECT

    Q_ENUMS(Format)

public:
    enum Format {
        OriginalFormat = 0,
        MP3,
        Unknown
    };
};

class Queries : public QObject
{
    Q_OBJECT

    Q_ENUMS(QueryType)
    Q_ENUMS(QueryOrder)

public:
    enum QueryType {
        Tracks = 0,
        Playlists,
        Users,
        Groups
    };

    enum QueryOrder {
        Date = 0,
        Hotness
    };
};

class Services : public QObject
{
    Q_OBJECT

    Q_ENUMS(AudioService)

public:
    enum AudioService {
        SoundCloud = 0,
        NoService
    };
};

class Activities : public QObject
{
    Q_OBJECT

    Q_ENUMS(ActivityType)

public:
    enum ActivityType {
        Track = 0,
        Playlist,
        TrackSharing,
        Comment,
        Favouriting
    };
};

class Transfers : public QObject
{
    Q_OBJECT

    Q_ENUMS(TransferStatus)
    Q_ENUMS(TransferPriority)
    Q_ENUMS(TransferType)

public:
    enum TransferStatus {
        Paused = 0,
        Cancelled,
        Failed,
        Completed,
        Queued,
        Connecting,
        Downloading,
        Uploading
    };

    enum TransferPriority {
        HighPriority = 0,
        NormalPriority,
        LowPriority
    };

    enum TransferType {
        TrackDownload = 0,
        PlaylistDownload,
        TrackUpload,
        PlaylistUpload
    };
};

class ScreenOrientation : public QObject
{
    Q_OBJECT

    Q_ENUMS(Orientation)

public:
    enum Orientation {
        Automatic = 0,
        LockPortrait,
        LockLandscape
    };
};

class NetworkProxyType : public QObject
{
    Q_OBJECT

    Q_ENUMS(ProxyType)

public:
    enum ProxyType {
        Socks5Proxy = QNetworkProxy::Socks5Proxy,
        HttpProxy = QNetworkProxy::HttpProxy,
        HttpCachingProxy = QNetworkProxy::HttpCachingProxy
    };
};

#endif // ENUMS_H
