#ifndef TRACKLISTTAB_H
#define TRACKLISTTAB_H

#include "abstracttab.h"
#include "../base/trackitem.h"

class TrackListModel;
class ListView;
class QAction;
class QLabel;
class QGridLayout;
class QModelIndex;
class QMenu;

class TrackListTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit TrackListTab(QWidget *parent = 0);
    void setTrackFeed(const QUrl &feed);

protected:
    void showEvent(QShowEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void addTracksToFavourites();
    void deleteTracksFromFavourites();
    void addTrackDownloads();
    void queueTracks();
    void showContextMenu(const QPoint &pos);
    void toggleFavourite();
    void addTrackDownload();
    void queueTrack();
    void onItemClicked(const QModelIndex &index);
    void showTrackInfo(QSharedPointer<TrackItem> track);
    void playTrack(const QModelIndex &index);

private:
    TrackListModel *m_model;
    ListView *m_listView;
    QAction *m_addToFavouritesAction;
    QAction *m_deleteFromFavouritesAction;
    QAction *m_addToQueueAction;
    QAction *m_trackDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_favouritesContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_trackDownloadContextAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // TRACKLISTTAB_H
