#include "soundcloudwebview.h"
#include "webview.h"
#include "../base/soundcloud.h"
#include <QProgressBar>
#include <QVBoxLayout>

SoundCloudWebView::SoundCloudWebView(QWidget *parent) :
    AbstractDialog(parent),
    m_view(new WebView(this)),
    m_progressBar(new QProgressBar(this))
{
    this->setWindowTitle(tr("Connect to SoundCloud"));
    this->setAttribute(Qt::WA_DeleteOnClose, false);

    m_view->enableSelectionSuppressor();
    m_progressBar->setTextVisible(false);

    QVBoxLayout *vbox = new QVBoxLayout(this);
    vbox->addWidget(m_view);
    vbox->addWidget(m_progressBar);

    this->connect(m_view, SIGNAL(urlChanged(QUrl)), this, SLOT(onUrlChanged(QUrl)));
    this->connect(m_view, SIGNAL(loadProgress(int)), m_progressBar, SLOT(setValue(int)));
    this->connect(m_view, SIGNAL(loadStarted()), m_progressBar, SLOT(show()));
    this->connect(m_view, SIGNAL(loadFinished(bool)), m_progressBar, SLOT(hide()));

    this->onOrientationChanged();
}

void SoundCloudWebView::onUrlChanged(const QUrl &url) {
    if (url.toString().startsWith("http://www.musikloud.co.uk")) {
        SoundCloud::instance()->signIn(url);
        this->accept();
    }
}

void SoundCloudWebView::showEvent(QShowEvent *event) {
    m_view->setUrl(SoundCloud::instance()->authUrl());
    AbstractDialog::showEvent(event);
}

void SoundCloudWebView::hideEvent(QHideEvent *event) {
    m_view->setUrl(QUrl());
    AbstractDialog::hideEvent(event);
}
