#ifndef PLAYLISTLISTWINDOW_H
#define PLAYLISTLISTWINDOW_H

#include "stackedwindow.h"
#include "../base/playlistitem.h"

class PlaylistListModel;
class ListView;
class QLabel;
class QModelIndex;

class PlaylistListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit PlaylistListWindow(QWidget *parent);
    void setPlaylistFeed(const QUrl &feed);
    void search(const QString &query, Queries::QueryOrder order);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showPlaylist(QSharedPointer<PlaylistItem> laylist);

private:
    ListView *m_listView;
    PlaylistListModel *m_model;
    QLabel *m_noResultsLabel;
};

#endif // PLAYLISTLISTWINDOW_H
