#ifndef NOWPLAYINGWINDOW_H
#define NOWPLAYINGWINDOW_H

#include "stackedwindow.h"

class QMenu;
class QActionGroup;
class QStackedWidget;
class NowPlayingMediaTab;
class NowPlayingInfoTab;

class NowPlayingWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit NowPlayingWindow(QWidget *parent = 0);

private:
    inline bool hasNowPlayingButton() const { return false; }
    void clearMenuActions();

private slots:
    void showMediaTab();
    void showInfoTab();
    void onCountChanged(int count);
    
private:
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_mediaAction;
    QAction *m_infoAction;
    QStackedWidget *m_stack;
    NowPlayingMediaTab *m_mediaTab;
    NowPlayingInfoTab *m_infoTab;
};

#endif // NOWPLAYINGWINDOW_H
