#include "mediaplayerbutton.h"
#include "../mediaplayer/mobility/mediaplayer.h"
#include <QPainter>
#include <QPaintEvent>
#include <QMaemo5Style>

MediaPlayerButton::MediaPlayerButton(Role buttonRole, QWidget *parent) :
    QAbstractButton(parent),
    m_role(buttonRole)
{
    this->setAttribute(Qt::WA_TranslucentBackground, true);
    this->setStyleSheet("background:transparent");
    this->setFixedSize(64, 64);

    QFont font;
    font.setPixelSize(14);
    font.setBold(true);

    this->setFont(font);

    switch (m_role) {
    case PlayPause:
        this->connect(MediaPlayer::instance(), SIGNAL(stateChanged(QMediaPlayer::State)), this, SLOT(update()));
        this->connect(this, SIGNAL(clicked()), MediaPlayer::instance(), SLOT(togglePlayPause()));
        break;
    case Previous:
        this->connect(this, SIGNAL(clicked()), MediaPlayer::instance(), SLOT(previous()));
        break;
    case Next:
        this->connect(this, SIGNAL(clicked()), MediaPlayer::instance(), SLOT(next()));
        break;
    case Repeat:
        this->connect(MediaPlayer::instance(), SIGNAL(playbackModeChanged(PlaybackMode::Mode)), this, SLOT(update()));
        this->connect(this, SIGNAL(clicked()), MediaPlayer::instance(), SLOT(togglePlaybackMode()));
        break;
    default:
        break;
    }
}

void MediaPlayerButton::paintEvent(QPaintEvent *event) {
    QPainter painter(this);

    switch (m_role) {
    case PlayPause:
        switch (MediaPlayer::instance()->state()) {
        case QMediaPlayer::PlayingState:
            painter.drawImage(this->rect(), QImage("/etc/hildon/theme/mediaplayer/Pause.png"));
            break;
        default:
            painter.drawImage(this->rect(), QImage("/etc/hildon/theme/mediaplayer/Play.png"));
            break;
        }

        break;
    case Previous:
        painter.drawImage(this->rect(), this->isDown() ? QImage("/etc/hildon/theme/mediaplayer/BackPressed.png") : QImage("/etc/hildon/theme/mediaplayer/Back.png"));
        break;
    case Next:
        painter.drawImage(this->rect(), this->isDown() ? QImage("/etc/hildon/theme/mediaplayer/ForwardPressed.png") : QImage("/etc/hildon/theme/mediaplayer/Forward.png"));
        break;
    case Shuffle:
        painter.drawImage(this->rect(), this->isDown() ? QImage("/etc/hildon/theme/mediaplayer/ShufflePressed.png") : QImage("/etc/hildon/theme/mediaplayer/Shuffle.png"));
        break;
    case Repeat:
        switch (MediaPlayer::instance()->playbackMode()) {
        case PlaybackMode::RepeatAll:
            painter.drawImage(this->rect(), QImage("/etc/hildon/theme/mediaplayer/RepeatPressed.png"));
            break;
        case PlaybackMode::RepeatOne:
            painter.drawImage(this->rect(), QImage("/etc/hildon/theme/mediaplayer/RepeatPressed.png"));
            painter.setFont(this->font());
            painter.setPen(QMaemo5Style::standardColor("ActiveTextColor"));
            painter.drawText(50, 20, "1");
            break;
        default:
            painter.drawImage(this->rect(), this->isDown() ? QImage("/etc/hildon/theme/mediaplayer/RepeatPressed.png") : QImage("/etc/hildon/theme/mediaplayer/Repeat.png"));
            break;
        }

        break;
    default:
        this->icon().paint(&painter, this->rect());
        break;
    }

    event->accept();
}
