#include "commentdelegate.h"
#include "../base/commentlistmodel.h"
#include <QApplication>
#include <QMouseEvent>
#include <QPainter>
#include <QMaemo5Style>

CommentDelegate::CommentDelegate(QObject *parent, bool interactive) :
    QStyledItemDelegate(parent),
    m_interactive(interactive)
{
}

void CommentDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    bool avatarPressed = index.data(CommentListModel::AvatarPressedRole).toBool();

    if (((option.state) & (QStyle::State_Selected)) && (!avatarPressed)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }

    QRect backgroundRect = option.rect;
    backgroundRect.setLeft(backgroundRect.left() + 8);
    backgroundRect.setRight(backgroundRect.right() - 8);
    backgroundRect.setTop(backgroundRect.top() + 8);

    QRect artistRect = backgroundRect;
    artistRect.setLeft(artistRect.left() + 64);

    QFont newFont;
    newFont.setPixelSize(20);
    painter->setFont(newFont);
    painter->setPen(QMaemo5Style::standardColor("SecondaryTextColor"));

    QString artistText = QString("%1 - %2").arg(index.data(CommentListModel::ArtistRole).toString(), index.data(CommentListModel::DateRole).toString());

    painter->drawText(artistRect, Qt::AlignTop | Qt::TextWordWrap, artistText);

    if ((option.state) & (QStyle::State_Selected) && (avatarPressed)) {
        painter->setOpacity(0.5);
    }

    QImage avatar = index.data(CommentListModel::ArtistAvatarRole).value<QImage>();

    if (!avatar.isNull()) {
        painter->drawImage(backgroundRect.left(), backgroundRect.top(), avatar);
    }

    painter->restore();

    QRect bodyRect = backgroundRect;
    bodyRect.setTop(bodyRect.top() + 56);
    bodyRect.setLeft(bodyRect.left() + 64);

    painter->drawText(bodyRect, Qt::TextWordWrap, index.data(CommentListModel::BodyRole).toString());
}

bool CommentDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index) {
    if (!m_interactive) {
        return false;
    }

    if (event->type() == QEvent::MouseButtonPress) {
        QMouseEvent *mouse = static_cast<QMouseEvent*>(event);

        QRect avatarRect = option.rect;
        avatarRect.setLeft(avatarRect.left() + 8);
        avatarRect.setTop(avatarRect.top() + 8);
        avatarRect.setSize(QSize(48, 48));

        if (avatarRect.contains(mouse->pos())) {
            model->setData(index, index.row(), CommentListModel::AvatarPressedRole);
        }

        return true;
    }

    if (event->type() == QEvent::MouseButtonRelease) {
        QMouseEvent *mouse = static_cast<QMouseEvent*>(event);

        if (index.data(CommentListModel::AvatarPressedRole).toBool()) {
            QRect avatarRect = option.rect;
            avatarRect.setLeft(avatarRect.left() + 8);
            avatarRect.setTop(avatarRect.top() + 8);
            avatarRect.setSize(QSize(48, 48));

            if (avatarRect.contains(mouse->pos())) {
                emit showUserChannel(index);
            }
        }

        model->setData(index, -1, CommentListModel::AvatarPressedRole);

        return true;
    }

    return false;
}

QSize CommentDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    return QSize(option.rect.width(), option.fontMetrics.boundingRect(option.rect, Qt::TextWordWrap, index.data(CommentListModel::BodyRole).toString()).height() + 100);
}
