#include "activitieswindow.h"
#include "../base/activitylistmodel.h"
#include "../base/feedurls.h"
#include "../base/soundcloud.h"
#include "../mediaplayer/mobility/mediaplayer.h"
#include "../base/settings.h"
#include "../base/tracklauncher.h"
#include "listview.h"
#include "activitylistdelegate.h"
#include "nowplayingwindow.h"
#include "channelwindow.h"
#include "trackinfowindow.h"
#include "playlisttrackswindow.h"
#include "nowplayingbutton.h"
#include <QLabel>
#include <QMenuBar>
#include <QMaemo5Style>

ActivitiesWindow::ActivitiesWindow(QWidget *parent) :
    StackedWindow(parent),
    m_model(new ActivityListModel(this)),
    m_view(new ListView(this)),
    m_refreshAction(this->menuBar()->addAction(tr("Refresh"), m_model, SLOT(reset()))),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No activities found")), this))
{
    this->setWindowTitle(tr("Dashboard"));
    this->setCentralWidget(m_view);

    ActivityListDelegate *delegate = new ActivityListDelegate(m_view);

    m_view->setModel(m_model);
    m_view->setItemDelegate(delegate);
    m_view->setMonitorScrolling(true);

    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(toggleBusy(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(delegate, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(delegate, SIGNAL(play(QModelIndex)), this, SLOT(onPlayClicked(QModelIndex)));
    this->connect(delegate, SIGNAL(showUserChannel(QModelIndex)), this, SLOT(showUserChannel(QModelIndex)));
    this->connect(m_view, SIGNAL(atEnd()), m_model, SLOT(getMoreActivities()));

    if (Settings::instance()->mediaPlayer() == "musikloud") {
        this->connect(m_view, SIGNAL(scrollingStarted()), NowPlayingButton::instance(), SLOT(hide()));
        this->connect(m_view, SIGNAL(scrollingStopped()), NowPlayingButton::instance(), SLOT(poke()));
    }

    m_model->getActivities(ALL_ACTIVITIES_FEED);

    this->onOrientationChanged();
}

void ActivitiesWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void ActivitiesWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void ActivitiesWindow::onCountChanged(int count) {
    m_noResultsLabel->setVisible(count == 0);
}

void ActivitiesWindow::onItemClicked(const QModelIndex &index) {
    switch (index.data(ActivityListModel::ActivityTypeRole).toInt()) {
    case Activities::Playlist:
        SoundCloud::instance()->getFullPlaylist(index.data(ActivityListModel::IdRole).toString());
        this->connect(SoundCloud::instance(), SIGNAL(gotPlaylist(QSharedPointer<PlaylistItem>)), this, SLOT(showPlaylist(QSharedPointer<PlaylistItem>)));
        return;
    default:
        SoundCloud::instance()->getFullTrack(index.data(ActivityListModel::IdRole).toString());
        this->connect(SoundCloud::instance(), SIGNAL(gotTrack(QSharedPointer<TrackItem>)), this, SLOT(showTrackInfo(QSharedPointer<TrackItem>)));
        return;
    }
}

void ActivitiesWindow::onPlayClicked(const QModelIndex &index) {
    SoundCloud::instance()->getFullTrack(index.data(ActivityListModel::IdRole).toString());
    this->connect(SoundCloud::instance(), SIGNAL(gotTrack(QSharedPointer<TrackItem>)), this, SLOT(playTrack(QSharedPointer<TrackItem>)));
}

void ActivitiesWindow::showUserChannel(const QModelIndex &index) {
    ChannelWindow *window = new ChannelWindow(index.data(ActivityListModel::ArtistIdRole).toString(), this);
    window->show();
}

void ActivitiesWindow::showTrackInfo(QSharedPointer<TrackItem> track) {
    this->disconnect(SoundCloud::instance(), SIGNAL(gotTrack(QSharedPointer<TrackItem>)), this, SLOT(showTrackInfo(QSharedPointer<TrackItem>)));

    TrackInfoWindow *window = new TrackInfoWindow(track, this);
    window->show();
}

void ActivitiesWindow::showPlaylist(QSharedPointer<PlaylistItem> playlist) {
    this->disconnect(SoundCloud::instance(), SIGNAL(gotPlaylist(QSharedPointer<PlaylistItem>)), this, SLOT(showPlaylist(QSharedPointer<PlaylistItem>)));

    PlaylistTracksWindow *window = new PlaylistTracksWindow(playlist, this);
    window->show();
}

void ActivitiesWindow::playTrack(QSharedPointer<TrackItem> track) {
    this->disconnect(SoundCloud::instance(), SIGNAL(gotTrack(QSharedPointer<TrackItem>)), this, SLOT(playTrack(QSharedPointer<TrackItem>)));

    if (Settings::instance()->mediaPlayer() == "musikloud") {
        MediaPlayer::instance()->playTrack(track);
        NowPlayingWindow *window = new NowPlayingWindow(this);
        window->show();
    }
    else {
        TrackLauncher::launchTrack(SoundCloud::instance()->getStreamUrl(track.data()->streamUrl()));
    }
}
