#include "windowstack.h"
#include <QFocusEvent>

WindowStack::WindowStack(QWidget *parent) :
    QStackedWidget(parent)
{
}

WindowStack::~WindowStack() {}

void WindowStack::focusInEvent(QFocusEvent *event) {
    if ((event->gotFocus()) && (this->currentWidget())) {
        this->currentWidget()->setFocus(Qt::OtherFocusReason);
    }

    QStackedWidget::focusInEvent(event);
}

void WindowStack::push(QWidget *widget) {
    this->addWidget(widget);
    this->setCurrentWidget(widget);
    this->setFocus(Qt::OtherFocusReason);
    emit pushed(widget->windowTitle());
}

void WindowStack::pop(int to) {
    if ((to < 0) || (to >= this->count())) {
        to = this->count() - 1;
    }

    while ((this->count() > (to + 1)) && (this->count() > 1)) {
        if (QWidget *widget = this->widget(this->count() - 1)) {
            this->removeWidget(widget);
            widget->close();
        }
    }

    if (this->count()) {
        this->setCurrentIndex(this->count() - 1);

        if (this->currentWidget()) {
            this->setFocus(Qt::OtherFocusReason);
        }
    }
}
