#include "toolbutton.h"
#include <QPainter>
#include <QPaintEvent>

ToolButton::ToolButton(QWidget *parent) :
    QToolButton(parent)
{
    this->setFixedSize(50, 40);
}

ToolButton::~ToolButton() {}

void ToolButton::paintEvent(QPaintEvent *event) {
    QPainter painter(this);

    QString state("normal");

    if (!this->isEnabled()) {
        state = "disabled";
    }
    else if ((this->isDown()) || (this->isChecked())) {
        state = "pressed";
    }

    painter.drawImage(this->rect(), QImage(QString("/usr/share/themes/default/images/qgn_plat_toolbar_button_%1.png").arg(state)));

    this->icon().paint(&painter, this->rect());

    event->accept();
}
