#ifndef SIGNINDIALOG_H
#define SIGNINDIALOG_H

#include <QDialog>

class QLabel;
class QLineEdit;
class QDialogButtonBox;
class QGridLayout;

class SignInDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SignInDialog(QWidget *parent = 0);
    ~SignInDialog();
    
    QString usernameLabel() const;
    void setUsernameLabel(const QString &label);

    QString passwordLabel() const;
    void setPasswordLabel(const QString &label);

public slots:
    void accept();

signals:
    void gotCredentials(const QString &username, const QString &password);

private:
    QLabel *m_userLabel;
    QLabel *m_passLabel;
    QLineEdit *m_userEdit;
    QLineEdit *m_passEdit;
    QDialogButtonBox *m_buttonBox;
    QGridLayout *m_grid;
};

#endif // SIGNINDIALOG_H
