#include "signindialog.h"
#include <QLabel>
#include <QLineEdit>
#include <QDialogButtonBox>
#include <QGridLayout>

SignInDialog::SignInDialog(QWidget *parent) :
    QDialog(parent),
    m_userLabel(new QLabel(tr("Username") + ":", this)),
    m_passLabel(new QLabel(tr("Password") + ":", this)),
    m_userEdit(new QLineEdit(this)),
    m_passEdit(new QLineEdit(this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel, Qt::Horizontal, this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Sign in"));
    this->setAttribute(Qt::WA_DeleteOnClose);

    m_passEdit->setEchoMode(QLineEdit::Password);

    m_grid->addWidget(m_userLabel, 0, 0);
    m_grid->addWidget(m_userEdit, 0, 1);
    m_grid->addWidget(m_passLabel, 1, 0);
    m_grid->addWidget(m_passEdit, 1, 1);
    m_grid->addWidget(m_buttonBox, 2, 0, 1, 2);

    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    this->connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
}

SignInDialog::~SignInDialog() {}

void SignInDialog::accept() {
    if ((!m_userEdit->text().isEmpty()) && (!m_passEdit->text().isEmpty())) {
        emit gotCredentials(m_userEdit->text(), m_passEdit->text());
    }

    QDialog::accept();
}
