#ifndef SHAREDIALOG_H
#define SHAREDIALOG_H

#include "../base/trackitem.h"
#include <QDialog>
#include <QSharedPointer>

class SeparatorLabel;
class ConnectionListModel;
class QModelIndex;
class QVBoxLayout;
class QDialogButtonBox;
class QPlainTextEdit;
class QLabel;
class QListView;

class ShareDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ShareDialog(QSharedPointer<TrackItem> track, QWidget *parent = 0);
    ~ShareDialog();
    
private slots:
    void onMessageChanged();
    void onListItemActvated(const QModelIndex &index);
    void shareTrack();

private:
    QSharedPointer<TrackItem> m_track;
    QLabel *m_messageLabel;
    QPlainTextEdit *m_messageEdit;
    SeparatorLabel *m_separator;
    ConnectionListModel *m_model;
    QListView *m_view;
    QDialogButtonBox *m_buttonBox;
    QVBoxLayout *m_vbox;
};

#endif // SHAREDIALOG_H
