#include "sharedialog.h"
#include "separatorlabel.h"
#include "connectionlistdelegate.h"
#include "../base/connectionlistmodel.h"
#include "../base/soundcloud.h"
#include <QLabel>
#include <QPlainTextEdit>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QListView>
#include <QVBoxLayout>

ShareDialog::ShareDialog(QSharedPointer<TrackItem> track, QWidget *parent) :
    QDialog(parent),
    m_track(track),
    m_messageLabel(new QLabel(tr("Your message"), this)),
    m_messageEdit(new QPlainTextEdit(this)),
    m_separator(new SeparatorLabel(tr("Connections"), this)),
    m_model(new ConnectionListModel(this)),
    m_view(new QListView(this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Cancel | QDialogButtonBox::Ok, Qt::Horizontal, this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowTitle(tr("Share track"));
    this->setAttribute(Qt::WA_DeleteOnClose);

    m_messageEdit->setMaximumHeight(100);

    m_view->setModel(m_model);
    m_view->setItemDelegate(new ConnectionListDelegate(m_view));
    m_view->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_view->setMaximumHeight(68);

    m_buttonBox->button(QDialogButtonBox::Ok)->setEnabled(false);

    m_vbox->addWidget(m_messageLabel);
    m_vbox->addWidget(m_messageEdit);
    m_vbox->addWidget(m_separator);
    m_vbox->addWidget(m_view);
    m_vbox->addWidget(m_buttonBox);

    m_model->getConnections();

    this->connect(m_view, SIGNAL(activated(QModelIndex)), this, SLOT(onListItemActvated(QModelIndex)));
    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(shareTrack()));
    this->connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
}

ShareDialog::~ShareDialog() {}

void ShareDialog::onMessageChanged() {
    m_buttonBox->button(QDialogButtonBox::Ok)->setEnabled((!m_messageEdit->toPlainText().isEmpty()) && (!m_model->connections().isEmpty()));
}

void ShareDialog::onListItemActvated(const QModelIndex &index) {
    if (index.isValid()) {
        m_model->toggleSelected(index.row());
    }

    m_buttonBox->button(QDialogButtonBox::Ok)->setEnabled((!m_messageEdit->toPlainText().isEmpty()) && (!m_model->connections().isEmpty()));
}

void ShareDialog::shareTrack() {
    SoundCloud::instance()->shareTrack(m_track.data()->id(), m_model->connections(), m_messageEdit->toPlainText());
    this->accept();
}
