#include "screen.h"
#include <QDBusConnection>

Screen* Screen::m_instance = 0;

Screen::Screen(QObject *parent) :
    QObject(parent)
{
    if (!m_instance) {
        m_instance = this;
    }

    QDBusConnection::systemBus().connect("",
                                         "/com/nokia/mce/signal",
                                         "com.nokia.mce.signal",
                                         "tklock_mode_ind",
                                         this,
                                         SLOT(onScreenLockStateChanged(QString)));
}

Screen::~Screen() {}

Screen* Screen::instance() {
    return !m_instance ? new Screen : m_instance;
}

void Screen::onScreenLockStateChanged(const QString &state) {
    if (state == "locked") {
        emit screenLockStateChanged(true);
    }
    else if (state == "unlocked") {
        emit screenLockStateChanged(false);
    }
}
