#ifndef NAVIGATIONBAR_H
#define NAVIGATIONBAR_H

#include <QAbstractButton>

class QHBoxLayout;
class NavigationBackButton;

class NavigationBar : public QWidget
{
    Q_OBJECT

public:
    explicit NavigationBar(QWidget *parent = 0);
    ~NavigationBar();

protected:
    void focusInEvent(QFocusEvent *event);
    void keyPressEvent(QKeyEvent *event);
    void paintEvent(QPaintEvent *event);
    
public slots:
    void push(const QString &title);
    void pop(int to = -1);

private slots:
    void onButtonClicked(QAbstractButton *button);

signals:
    void popped(int to);

private:
    NavigationBackButton *m_backButton;
    QButtonGroup *m_buttonGroup;
    QHBoxLayout *m_hbox;
};

class NavigationBackButton : public QAbstractButton
{
    Q_OBJECT

public:
    explicit NavigationBackButton(QWidget *parent = 0);
    ~NavigationBackButton();

protected:
    void keyPressEvent(QKeyEvent *event);
    void keyReleaseEvent(QKeyEvent *event);
    void paintEvent(QPaintEvent *event);
};

class NavigationButton : public QAbstractButton
{
    Q_OBJECT

public:
    explicit NavigationButton(const QString &text = QString(), QWidget *parent = 0);
    ~NavigationButton();

    QSize sizeHint() const;

    bool first() const;
    void setFirst(bool first);

    bool last() const;
    void setLast(bool last);

protected:
    void keyPressEvent(QKeyEvent *event);
    void keyReleaseEvent(QKeyEvent *event);
    void paintEvent(QPaintEvent *event);

private:
    bool m_first;
    bool m_last;
};

#endif // NAVIGATIONBAR_H
