#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "../base/trackitem.h"
#include "../base/playlistitem.h"
#include "../mediaplayer/phonon/mediaplayer.h"
#include <QMainWindow>

class WindowStack;
class ButtonBar;
class ToolBar;
class ToolButton;
class MediaPlayerButton;
class NowPlayingWindow;
class NavigationBar;
class QHBoxLayout;
class QVBoxLayout;
class QListView;
class QModelIndex;
class QActionGroup;
class QLabel;
class VolumeControl;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    static MainWindow* instance();

protected:
    bool event(QEvent *event);
    void keyPressEvent(QKeyEvent *event);

public slots:
    void setFullScreen(bool fullScreen);
    void push(QWidget *window);
    void pop(int to = -1);
    void search(const QString &query, Queries::QueryType type = Queries::Tracks, Queries::QueryOrder order = Queries::Hotness);
    void trackSearch(const QString &query, Queries::QueryOrder order = Queries::Hotness);
    void playlistSearch(const QString &query, Queries::QueryOrder order = Queries::Hotness);
    void groupSearch(const QString &query, Queries::QueryOrder order = Queries::Hotness);
    void userSearch(const QString &query);
    void showTrack(QSharedPointer<TrackItem> track);
    void showPlaylist(QSharedPointer<PlaylistItem> playlist);
    void showUserChannel(const QString &id);
    void playTrack(QSharedPointer<TrackItem> track);
    void displayTrack(const QStringList &urls);
    void displayTrack(const QString &url);
    void playTrack(const QStringList &urls);
    void playTrack(const QString &url);
    void displayPlaylist(const QStringList &urls);
    void displayPlaylist(const QString &url);
    void displayUser(const QStringList &urls);
    void displayUser(const QString &url);
    void displayResource(const QStringList &urls);
    void displayResource(const QString &url);

private slots:
    void onMediaStateChanged(Phonon::State state);
    void onPlaybackQueueChanged(int count);
    void onVolumeMutedChanged(bool muted);
    void onPlaybackPositionChanged(qint64 position);
    void onPlaybackDurationChanged(qint64 duration);
    void onListItemActivated(const QModelIndex &index);
    void toggleCurrentTab();
    void onCurrentTabChanged(int index);
    void showVolumeControl(bool show = false);
    void showHomeWindow();
    void showNowPlayingWindow();
    void showMyChannel();
    void showDashboard();
    void showExploreWindow(Queries::QueryType type, const QString &title, const QUrl &feed);
    void showTransfers();
    void showArchive();
    void showExploreDialog();
    void showSearchDialog();
    void showAccountsDialog();
    void showSettingsDialog();
    void showAboutDialog();
    void onResourceResolved(const QString &id, Queries::QueryType type);
    
private:
    static MainWindow* m_instance;
    QAction *m_searchAction;
    QAction *m_transfersAction;
    QAction *m_accountsAction;
    QAction *m_settingsAction;
    QMenu *m_playbackMenu;
    QAction *m_playPauseAction;
    QAction *m_stopAction;
    QAction *m_playbackSeparator;
    QAction *m_previousAction;
    QAction *m_nextAction;
    QAction *m_playbackSeparator2;
    QMenu *m_playbackModeMenu;
    QAction *m_playbackModeSeparator;
    QAction *m_sequentialAction;
    QAction *m_repeatAllAction;
    QAction *m_repeatOneAction;
    QAction *m_muteAction;
    QActionGroup *m_playbackModeGroup;
    QMenu *m_viewMenu;
    QAction *m_homeAction;
    QAction *m_nowPlayingAction;
    QAction *m_viewModeSeparator;
    QAction *m_fullscreenAction;
    QActionGroup *m_viewModeGroup;
    QAction *m_aboutAction;
    QAction *m_quitAction;
    ToolBar *m_toolBar;
    ToolButton *m_toggleVolumeButton;
    ToolButton *m_playbackModeButton;
    QLabel *m_positionLabel;
    Phonon::SeekSlider *m_slider;
    QLabel *m_durationLabel;
    ButtonBar *m_mediaButtonBar;
    MediaPlayerButton *m_previousButton;
    MediaPlayerButton *m_playPauseButton;
    MediaPlayerButton *m_stopButton;
    MediaPlayerButton *m_nextButton;
    VolumeControl *m_volumeControl;
    QTimer *m_volumeTimer;
    WindowStack *m_windowStack;
    QHBoxLayout *m_hbox;
    QVBoxLayout *m_vbox;
    QWidget *m_homeWindow;
    NowPlayingWindow *m_nowPlayingWindow;
    NavigationBar *m_navigationBar;
    QListView *m_view;
};

#endif // MAINWINDOW_H
