#ifndef EXPLOREDIALOG_H
#define EXPLOREDIALOG_H

#include "../base/enums.h"
#include <QDialog>

class ExploreModel;
class QListView;
class QModelIndex;
class QDialogButtonBox;
class QVBoxLayout;

class ExploreDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ExploreDialog(QWidget *parent = 0);
    ~ExploreDialog();

    void accept();

private slots:
    void onListItemActivated(const QModelIndex &index);

signals:
    void categoryChosen(Queries::QueryType type, const QString &title, const QUrl &feed);
    
private:
    ExploreModel *m_model;
    QListView *m_view;
    QDialogButtonBox *m_buttonBox;
    QVBoxLayout *m_vbox;
};

#endif // EXPLOREDIALOG_H
