#include "commentlistdelegate.h"
#include "../base/commentlistmodel.h"
#include "../base/utils.h"
#include <QPainter>
#include <QApplication>

CommentListDelegate::CommentListDelegate(QObject *parent) :
    ListDelegate(parent)
{
}

void CommentListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    QRect backgroundRect = option.rect;
    backgroundRect.setLeft(backgroundRect.left() + 8);
    backgroundRect.setRight(backgroundRect.right() - 8);
    backgroundRect.setTop(backgroundRect.top() + 8);

    QRect artistRect = backgroundRect;
    artistRect.setLeft(artistRect.left() + 64);

    painter->setPen(QApplication::palette().color(QPalette::Mid));

    QString artistText = QString("%1 - %2").arg(index.data(CommentListModel::ArtistRole).toString(), index.data(CommentListModel::DateRole).toString());

    painter->drawText(artistRect, Qt::AlignTop | Qt::TextWordWrap, artistText);

    QImage avatar = index.data(CommentListModel::ArtistAvatarRole).value<QImage>();

    if (!avatar.isNull()) {
        painter->drawImage(backgroundRect.left(), backgroundRect.top(), avatar);
    }

    painter->restore();

    QRect bodyRect = backgroundRect;
    bodyRect.setTop(bodyRect.top() + 56);
    bodyRect.setLeft(bodyRect.left() + 64);

    painter->drawText(bodyRect, Qt::TextWordWrap, index.data(CommentListModel::BodyRole).toString());
}

QSize CommentListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    return QSize(option.rect.width(), option.fontMetrics.boundingRect(option.rect, Qt::TextWordWrap, index.data(CommentListModel::BodyRole).toString()).height() + 100);
}
