#include "accountsdialog.h"
#include "signindialog.h"
#include "../base/soundcloud.h"
#include "../base/lastfm.h"
#include "../base/database.h"
#include <QLabel>
#include <QPushButton>
#include <QDialogButtonBox>
#include <QVBoxLayout>

AccountsDialog::AccountsDialog(QWidget *parent) :
    QDialog(parent),
    m_soundcloudLabel(new QLabel(this)),
    m_lastfmLabel(new QLabel(this)),
    m_soundcloudButton(new QPushButton(this)),
    m_lastfmButton(new QPushButton(this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Ok, Qt::Horizontal, this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowTitle(tr("Accounts"));
    this->setAttribute(Qt::WA_DeleteOnClose);

    m_vbox->addWidget(m_soundcloudLabel);
    m_vbox->addWidget(m_soundcloudButton);
    m_vbox->addWidget(m_lastfmLabel);
    m_vbox->addWidget(m_lastfmButton);
    m_vbox->addWidget(m_buttonBox);

    this->onSoundCloudSignedInChanged(SoundCloud::instance()->userSignedIn());
    this->onLastfmSignedInChanged(Lastfm::instance()->userSignedIn());

    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
}

AccountsDialog::~AccountsDialog() {}

void AccountsDialog::showSoundCloudSignInDialog() {
    SignInDialog *dialog = new SignInDialog(this);
    dialog->open();

    this->connect(dialog, SIGNAL(gotCredentials(QString,QString)), SoundCloud::instance(), SLOT(signIn(QString,QString)));
}

void AccountsDialog::showLastfmSignInDialog() {
    SignInDialog *dialog = new SignInDialog(this);
    dialog->open();

    this->connect(dialog, SIGNAL(gotCredentials(QString,QString)), Lastfm::instance(), SLOT(signIn(QString,QString)));
}

void AccountsDialog::onSoundCloudSignedInChanged(bool signedIn) {
    this->disconnect(m_soundcloudButton, SIGNAL(clicked()), 0, 0);

    if (signedIn) {
        m_soundcloudLabel->setText(tr("You have connnected your SoundCloud account"));
        m_soundcloudButton->setText(tr("Disconnect"));

        this->connect(m_soundcloudButton, SIGNAL(clicked()), Database::instance(), SLOT(deleteSoundCloudAccount()));
    }
    else {
        m_soundcloudLabel->setText(tr("Connect your SoundCloud account"));
        m_soundcloudButton->setText(tr("Connect"));

        this->connect(m_soundcloudButton, SIGNAL(clicked()), this, SLOT(showSoundCloudSignInDialog()));
    }
}

void AccountsDialog::onLastfmSignedInChanged(bool signedIn) {
    this->disconnect(m_lastfmButton, SIGNAL(clicked()), 0, 0);

    if (signedIn) {
        m_lastfmLabel->setText(tr("You are signed in to you Last.fm account"));
        m_lastfmButton->setText(tr("Sign out"));

        this->connect(m_lastfmButton, SIGNAL(clicked()), Database::instance(), SLOT(deleteLastfmAccount()));
    }
    else {
        m_lastfmLabel->setText(tr("Sign in to your Last.fm account"));
        m_lastfmButton->setText(tr("Sign in"));

        this->connect(m_lastfmButton, SIGNAL(clicked()), this, SLOT(showLastfmSignInDialog()));
    }
}
