#ifndef SESSION_H
#define SESSION_H

#include <QObject>

class Settings;
class Database;
class PlaybackListModel;
class SoundCloud;
class Lastfm;
class Notifications;
class TransferManager;
class ClipboardMonitor;
class QNetworkAccessManager;
#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#ifdef Q_WS_MAEMO_5
class WindowStack;
#endif
#endif
#if (defined (MEDIA_PLAYERS_ENABLED)) && (defined (QML_USER_INTERFACE))
class TrackLauncher;
#endif

class Session : public QObject
{
    Q_OBJECT

public:
    explicit Session(QObject *parent = 0);
    ~Session();
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }

    static Session* instance();
    
private:
    static Session *m_instance;
    QNetworkAccessManager *m_nam;
    Settings *m_settings;
    Database *m_database;
#if (defined (MEDIA_PLAYERS_ENABLED)) && (defined (QML_USER_INTERFACE))
    TrackLauncher *m_launcher;
#endif
    PlaybackListModel *m_queue;
    SoundCloud *m_soundcloud;
    Lastfm *m_lastfm;
    Notifications *m_notifications;
    TransferManager *m_transferManager;
    ClipboardMonitor *m_monitor;
#ifndef QML_USER_INTERFACE
    ThumbnailCache *m_cache;
#ifdef Q_WS_MAEMO_5
    WindowStack *m_stack;
#endif
#endif
};

#endif // SESSION_H
