#include "playlistitem.h"
#include "utils.h"

PlaylistItem::PlaylistItem(QObject *parent) :
    QObject(parent),
    m_duration(0),
    m_trackCount(0),
    m_service(Services::NoService)
{
}

PlaylistItem::PlaylistItem(PlaylistItem *playlist, QObject *parent) :
    QObject(parent),
    m_id(playlist->id()),
    m_title(playlist->title()),
    m_artist(playlist->artist()),
    m_artistId(playlist->artistId()),
    m_artistAvatarUrl(playlist->artistAvatarUrl()),
    m_description(playlist->description()),
    m_duration(playlist->duration()),
    m_date(playlist->date()),
    m_genre(playlist->genre()),
    m_thumbnailUrl(playlist->thumbnailUrl()),
    m_trackCount(playlist->trackCount()),
    m_service(playlist->service())
{
}

PlaylistItem::PlaylistItem(const QVariantMap &playlist, QObject *parent) :
    QObject(parent),
    m_id(playlist.value("id").toString()),
    m_title(playlist.value("title").toString()),
    m_artist(playlist.value("user").toMap().value("username").toString()),
    m_artistId(playlist.value("user").toMap().value("id").toString()),
    m_artistAvatarUrl(playlist.value("user").toMap().value("avatar_url").toString()),
    m_description(playlist.value("description").toString().remove('\r')),
    m_duration(playlist.value("duration").toInt()),
    m_date(Utils::localDateTimeFromString(playlist.value("created_at").toString().section(' ', 0, 1))),
    m_genre(playlist.value("genre").toString()),
    m_thumbnailUrl(playlist.value("artwork_url").toString()),
    m_trackCount(playlist.value("track_count").toInt()),
    m_service(Services::SoundCloud)
{
}

void PlaylistItem::loadPlaylist(PlaylistItem *playlist) {
    this->setId(playlist->id());
    this->setTitle(playlist->title());
    this->setArtist(playlist->artist());
    this->setArtistId(playlist->artistId());
    this->setArtistAvatarUrl(playlist->artistAvatarUrl());
    this->setDescription(playlist->description());
    this->setDuration(playlist->duration());
    this->setDate(playlist->date());
    this->setGenre(playlist->genre());
    this->setThumbnailUrl(playlist->thumbnailUrl());
    this->setTrackCount(playlist->trackCount());
    this->setService(playlist->service());
}
